#version 330 compatibility



/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/

/////////ADJUSTABLE VARIABLES//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////ADJUSTABLE VARIABLES//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



//#define HALF_RES_TRACE

/////////INTERNAL VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////INTERNAL VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Do not change the name of these variables or their type. The Shaders Mod reads these lines and determines values to send to the inner-workings
//of the shaders mod. The shaders mod only reads these lines and doesn't actually know the real value assigned to these variables in GLSL.
//Some of these variables are critical for proper operation. Change at your own risk.

const bool colortex4Clear = false;
const bool colortex5Clear = false;
//END OF INTERNAL VARIABLES//




in vec4 texcoord;

in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorSkyUp;
in vec3 colorTorchlight;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;


in vec3 worldLightVector;
in vec3 worldSunVector;


in mat4 gbufferPreviousModelViewInverse;
in mat4 gbufferPreviousProjectionInverse;


#include "lib/Uniforms.inc"
#include "lib/Common.inc"

#include "lib/Materials.inc"


/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////






// vec4 GetViewPosition(in vec2 coord, in float depth) 
// {	
// 	vec2 tcoord = coord;
// 	TemporalJitterProjPosInv01(tcoord);

// 	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
// 		 fragposition /= fragposition.w;

	
// 	return fragposition;
// }




vec2 GetNearFragment(vec2 coord, float depth, out float minDepth)
{
	
	
	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);
	vec4 depthSamples;
	depthSamples.x = texture2D(depthtex1, coord + texel * vec2(1.0, 1.0)).x;
	depthSamples.y = texture2D(depthtex1, coord + texel * vec2(1.0, -1.0)).x;
	depthSamples.z = texture2D(depthtex1, coord + texel * vec2(-1.0, 1.0)).x;
	depthSamples.w = texture2D(depthtex1, coord + texel * vec2(-1.0, -1.0)).x;

	vec2 targetFragment = vec2(0.0, 0.0);

	if (depthSamples.x < depth)
		targetFragment = vec2(1.0, 1.0);
	if (depthSamples.y < depth)
		targetFragment = vec2(1.0, -1.0);
	if (depthSamples.z < depth)
		targetFragment = vec2(-1.0, 1.0);
	if (depthSamples.w < depth)
		targetFragment = vec2(-1.0, -1.0);


	minDepth = min(min(min(depthSamples.x, depthSamples.y), depthSamples.z), depthSamples.w);

	return coord + texel * targetFragment;
}










#include "lib/GBufferData.inc"





 int t(float v)
 {
   return int(floor(v));
 }
 int f(int v)
 {
   return v-t(mod(float(v),2.))-0;
 }
 int d(int v)
 {
   return v-t(mod(float(v),2.))-1;
 }
 int d()
 {
   ivec2 v=ivec2(viewWidth,viewHeight);
   int y=v.x*v.y;
   return f(t(floor(pow(float(y),.333333))));
 }
 int f()
 {
   ivec2 v=ivec2(2048,2048);
   int f=v.x*v.y;
   return d(t(floor(pow(float(f),.333333))));
 }
 vec3 v(vec2 v)
 {
   ivec2 f=ivec2(viewWidth,viewHeight);
   int x=f.x*f.y,y=d();
   ivec2 i=ivec2(v.x*f.x,v.y*f.y);
   float z=float(i.y/y),r=float(int(i.x+mod(f.x*z,y))/y);
   r+=floor(f.x*z/y);
   vec3 s=vec3(0.,0.,r);
   s.x=mod(i.x+mod(f.x*z,y),y);
   s.y=mod(i.y,y);
   s.xyz=floor(s.xyz);
   s/=y;
   s.xyz=s.xzy;
   return s;
 }
 vec2 s(vec3 v)
 {
   ivec2 f=ivec2(viewWidth,viewHeight);
   int z=d();
   vec3 i=v.xzy*z;
   i=floor(i+1e-05);
   float x=i.z;
   vec2 r;
   r.x=mod(i.x+x*z,f.x);
   float s=i.x+x*z;
   r.y=i.y+floor(s/f.x)*z;
   r+=.5;
   r/=f;
   return r;
 }
 vec3 e(vec2 v)
 {
   vec2 i=v;
   i.xy/=.5;
   ivec2 s=ivec2(2048,2048);
   int x=s.x*s.y,y=f();
   ivec2 d=ivec2(i.x*s.x,i.y*s.y);
   float z=float(d.y/y),r=float(int(d.x+mod(s.x*z,y))/y);
   r+=floor(s.x*z/y);
   vec3 m=vec3(0.,0.,r);
   m.x=mod(d.x+mod(s.x*z,y),y);
   m.y=mod(d.y,y);
   m.xyz=floor(m.xyz);
   m/=y;
   m.xyz=m.xzy;
   return m;
 }
 vec2 d(vec3 v,int y)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   ivec2 f=ivec2(2048,2048);
   vec3 i=v.xzy*y;
   i=floor(i+1e-05);
   float x=i.z;
   vec2 r;
   r.x=mod(i.x+x*y,f.x);
   float s=i.x+x*y;
   r.y=i.y+floor(s/f.x)*y;
   r+=.5;
   r/=f;
   r.xy*=.5;
   return r;
 }
 vec3 e(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 f(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v;
 }
 vec3 m(vec3 v)
 {
   int s=f();
   v=v-vec3(.5);
   v*=s;
   return v;
 }
 vec3 r(vec3 v)
 {
   int y=d();
   v*=1./y;
   v=v+vec3(.5);
   v=clamp(v,vec3(0.),vec3(1.));
   return v;
 }
 vec3 n(vec3 v)
 {
   int f=d();
   v=v-vec3(.5);
   v*=f;
   return v;
 }
 vec3 e()
 {
   vec3 v=cameraPosition.xyz+.5,i=previousCameraPosition.xyz+.5,f=floor(v-.0001),y=floor(i-.0001);
   return f-y;
 }
 vec3 x(vec3 v)
 {
   vec4 f=vec4(v,1.);
   f=shadowModelView*f;
   f=shadowProjection*f;
   f/=f.w;
   float x=sqrt(f.x*f.x+f.y*f.y),y=1.f-SHADOW_MAP_BIAS+x*SHADOW_MAP_BIAS;
   f.xy*=.95f/y;
   f.z=mix(f.z,.5,.8);
   f=f*.5f+.5f;
   f.xy*=.5;
   f.xy+=.5;
   return f.xyz;
 }
 vec3 d(vec3 v,vec3 f,vec3 y,vec3 z,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 i=x(v);
   float s=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(i.xy,i.z-.0006*s),0).x;
   r*=saturate(dot(f,y));
   {
     vec4 d=texture2DLod(shadowcolor1,i.xy-vec2(0.,.5),4);
     float w=abs(d.x*256.-(v.y+cameraPosition.y)),h=GetCausticsComposite(v,f,w),o=shadow2DLod(shadowtex0,vec3(i.xy-vec2(0.,.5),i.z+1e-06),4).x;
     r=mix(r,r*h,1.-o);
   }
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }
 vec3 e(vec3 v,vec3 f,vec3 y,vec3 z,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 i=m(v),s=x(i+y*.99);
   float r=.5;
   vec3 d=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*r),3).x;
   d*=saturate(dot(f,y));
   d=TintUnderwaterDepth(d);
   return d*(1.-rainStrength);
 }
 vec3 f(vec3 v,vec3 f,vec3 y,vec3 z,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 i=x(v);
   float s=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(i.xy,i.z-.0006*s),2).x;
   r*=saturate(dot(f,y));
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }struct GITemporalData2{float cNuyPQlxuC;float ZFucbkcOTp;float vfyvrzqkzI;float xSSGSkZnBe;vec3 MXlHQOttjo;};
 vec4 p(GITemporalData2 v)
 {
   vec4 f;
   v.MXlHQOttjo=max(vec3(0.),v.MXlHQOttjo);
   f.x=v.cNuyPQlxuC;
   v.MXlHQOttjo=pow(v.MXlHQOttjo,vec3(.25));
   f.y=PackTwo16BitTo32Bit(v.MXlHQOttjo.x,v.vfyvrzqkzI);
   f.z=PackTwo16BitTo32Bit(v.MXlHQOttjo.y,v.xSSGSkZnBe);
   f.w=PackTwo16BitTo32Bit(v.MXlHQOttjo.z,v.ZFucbkcOTp);
   return f;
 }
 GITemporalData2 h(vec4 v)
 {
   GITemporalData2 f;
   vec2 i=UnpackTwo16BitFrom32Bit(v.y),s=UnpackTwo16BitFrom32Bit(v.z),m=UnpackTwo16BitFrom32Bit(v.w);
   f.cNuyPQlxuC=v.x;
   f.vfyvrzqkzI=i.y;
   f.xSSGSkZnBe=s.y;
   f.ZFucbkcOTp=m.y;
   f.MXlHQOttjo=pow(vec3(i.x,s.x,m.x),vec3(4.));
   return f;
 }
 GITemporalData2 i(vec2 v)
 {
   vec2 f=1./vec2(viewWidth,viewHeight),y=vec2(viewWidth,viewHeight);
   v=(floor(v*y)+.5)*f;
   return h(texture2DLod(colortex5,v,0));
 }
 float h(float v,float y)
 {
   float f=1.;
   #ifdef FULL_RT_REFLECTIONS
   f=clamp(pow(v,.125)+y,0.,1.);
   #else
   f=clamp(v*10.-7.,0.,1.);
   #endif
   return f;
 }
 void d(inout float v,inout float f,float y,float i,vec3 z,float t)
 {
   v*=mix(2.4,2.4,i);
   float s=dot(z,vec3(1.));
   f*=1.-pow(i,.4);
   f/=y*.1+2e-06;
   f*=4.;
   f*=.6;
   float r=y/(s+1e-07)*.2+4e-08;
   r=min(r,1.);
   r=mix(r,1.,pow(i,.25));
   if(t<.12)
     f=0.;
 }
 float d(vec3 v,vec3 y,float f)
 {
   float r=dot(abs(v-y),vec3(.3333));
   r*=f;
   r*=.18;
   return r;
 }
 void e(inout vec3 v,vec2 f,vec3 y)
 {}
 float i(float v,float y)
 {
   return v/(y*20.01+1.);
 }struct Ray{vec3 dir;vec3 origin;};struct BBRay{vec3 origin;vec3 direction;vec3 inv_direction;ivec3 sign;};
 BBRay m(vec3 v,vec3 y)
 {
   vec3 f=vec3(1.)/y;
   return BBRay(v,y,f,ivec3(f.x<0?1:0,f.y<0?1:0,f.z<0?1:0));
 }
 void d(in BBRay v,in vec3 f[2],out float r,out float y)
 {
   float i,z,x,t;
   r=(f[v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   y=(f[1-v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   i=(f[v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   z=(f[1-v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   x=(f[v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   t=(f[1-v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   r=max(max(r,i),x);
   y=min(min(y,z),t);
 }
 vec2 c(inout float v)
 {
   return fract(sin(vec2(v+=.1,v+=.1))*vec2(43758.5,22578.1));
 }
 float w(vec2 v)
 {
   v*=vec2(viewWidth,viewHeight);
   const float f=1.61803,y=1.32472;
   return fract(dot(v,1./vec2(f,y*y)));
 }
 vec3 g(vec2 v)
 {
   vec2 f=vec2(v.xy*vec2(viewWidth,viewHeight))/64.;
   const vec2 s[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   else
      f+=s[int(mod(frameCounter,8.f))]*.5;
   f=(floor(f*64.)+.5)/64.;
   vec3 y=texture2D(noisetex,f).xyz,i=vec3(sqrt(.2),sqrt(2.),1.61803);
   return y;
 }
 vec3 c(vec3 v,inout float f,int y)
 {
   vec2 i=g(texcoord.xy+vec2(0.,0.)).xy;
   i=i*.99+.005;
   #if GI_RESPONSIVENESS<1
   #endif
   float r=6.28319*i.x,z=sqrt(i.y);
   vec3 s=normalize(cross(v,vec3(0.,1.,1.))),x=cross(v,s),t=s*cos(r)*z+x*sin(r)*z+v.xyz*sqrt(1.-i.y);
   return t;
 }
 vec3 B(inout float v)
 {
   vec3 f=g(texcoord.xy).xyz;
   f=fract(f+vec3(c(v),c(v).x)*.1);
   f=f*2.-1.;
   f=normalize(f);
   return f;
 }
 vec3 B(vec3 v,vec3 y)
 {
   vec2 f=s(r(m(v)+y+1.+e()));
   vec3 z=i(f).MXlHQOttjo;
   return z;
 }
 vec3 B()
 {
   vec2 f=s(v(texcoord.xy)+e()/d());
   vec3 y=i(f).MXlHQOttjo;
   return y;
 }
 bool c(ivec3 v,BBRay f)
 {
   vec3 y=vec3(v),z=vec3(v)+1.,r=mix(y,z,vec3(.5));
   float i=mix(.25,0.,saturate(distance(f.origin,r)*.5-1.));
   vec3 s[2]=vec3[2](mix(y,z,vec3(i)),mix(y,z,vec3(1.-i)));
   float x,t;
   d(f,s,x,t);
   return x<=t;
 }
 vec3 B(vec3 v,vec3 s,vec3 y,vec3 i,vec3 z,MaterialMask r,float x,vec2 h,float t,out float n)
 {
   float o=fract(frameCounter*.0123456),w=1.;
   #ifdef SUNLIGHT_LEAK_FIX
   if(isEyeInWater<1)
     w=saturate(x*100.);
   #endif
   float C=1.;
   #ifdef CAVE_GI_LEAK_FIX
   if(isEyeInWater<1)
     C=saturate(x*10.);
   #endif
   vec3 p=c(i,o,0);
   n=1000.;
   #ifdef GI_SCREEN_SPACE_TRACING
   bool G=false;
   {
     const int g=8;
     float l=.25*-s.z;
     l=mix(l,.8,.5);
     float D=.07*-s.z;
     D=mix(D,1.,.5);
     D=.4;
     vec2 M=texcoord.xy;
     vec3 a=s.xyz,I=normalize((gbufferModelView*vec4(p.xyz,0.)).xyz);
     for(int S=0;S<g;S++)
       {
         float F=float(S),k=(F+.5)/float(g),u=l*k;
         vec3 R=s.xyz+I*u,T=ProjectBack(R),P=GetViewPositionNoJitter(T.xy,GetDepth(T.xy)).xyz;
         float Z=length(R)-length(P)-.02;
         if(Z>0.&&Z<D)
           {
             G=true;
             M=T.xy;
             a=P.xyz;
             break;
           }
       }
     vec3 S=(gbufferModelViewInverse*vec4(a,1.)).xyz;
     S+=Fract01(cameraPosition.xyz+.5)+.5;
     if(G)
       {
         vec3 R=pow(texture2DLod(colortex7,M.xy-h*.5,0).xyz,vec3(2.2));
         R*=1.-saturate(t*1.1);
         return R*100.;
       }
   }
   #endif
   if(r.leaves>.5)
     ;
   int g=f();
   vec3 l=v+y*(.001-r.leaves*.01);
   l+=Fract01(cameraPosition.xyz+.5);
   vec3 S=l;
   l=e(l,g);
   float R=1./float(g);
   Ray T;
   T.origin=l*g-vec3(1.,1.,1.);
   T.dir=p;
   BBRay a=m(T.origin,T.dir);
   vec3 D=vec3(1.),M=vec3(0.);
   float Z=0.;
   {
     vec3 F=vec3(floor(T.origin)),k=abs(vec3(length(T.dir))/(T.dir+.0001)),I=sign(T.dir),P=(sign(T.dir)*(F-T.origin)+sign(T.dir)*.5+.5)*k,U;
     vec4 u=vec4(0.);
     vec3 b=vec3(0.);
     float L=.5;
     for(int E=0;E<DIFFUSE_TRACE_LENGTH;E++)
       {
         b=F/float(g);
         vec2 N=d(b,g);
         u=texture2DLod(shadowcolor,N,0);
         Z=u.w*255.;
         float H=1.-step(.5,abs(Z-241.));
         vec3 O=u.xyz;
         M+=O*H*L*.5;
         if(Z<240.&&E!=0)
           {
             break;
           }
         U=step(P.xyz,P.yzx)*step(P.xyz,P.zxy);
         P+=U*k;
         F+=U*I;
         L=1.;
       }
     float E=0.;
     if(Z<1.f||Z>254.f)
       {
         vec3 N=T.dir;
         if(isEyeInWater>0)
           N=refract(N,vec3(0.,-1.,0.),1.3333);
         vec3 O=SkyShading(N,worldSunVector,rainStrength);
         O*=saturate(N.y*10.+1.);
         O=DoNightEyeAtNight(O*12.,timeMidnight)*.083333;
         O=TintUnderwaterDepth(O);
         if(length(N)<.1)
           E=300.;
         M+=O*.1*C;
       }
     else
       {
         if(abs(Z-31.)<.1)
           M+=.09*D*u.xyz*GI_LIGHT_BLOCK_INTENSITY;
         if(Z<240.)
           {
             vec3 O=saturate(u.xyz);
             D*=O;
             vec3 N=-(U*I);
             M+=B(b,N)*D*1.5;
             vec3 H[2]=vec3[2](F,F+1.);
             float Y,A;
             d(a,H,Y,A);
             const float W=2.4;
             vec3 Q=f(S+T.dir*Y-1.,worldLightVector,N,p,g),V=DoNightEyeAtNight(Q*D*W*colorSunlight*w*C*12.,timeMidnight)/12.;
             M+=V;
             n=Y;
             E=n;
           }
       }
     {
       vec2 N=IntersectSphere(v,T.dir,vec3(0.,1.5,0.),.75);
       if(n>N.y&&N.y>-.5)
         ;
     }
     UnderwaterFog(M,E,p,colorSkyUp,colorSunlight);
   }
   if(r.grass<.5)
     M/=saturate(dot(i,p))+.01,M*=saturate(dot(y,p));
   return M;
 }
 vec3 c()
 {
   int y=f();
   vec3 i=v(texcoord.xy),s=n(i),r=e(s-vec3(1.,1.,0.),y);
   vec2 x=d(r,y);
   float z=1.;
   #ifdef CAVE_GI_LEAK_FIX
   if(isEyeInWater<1)
     z*=saturate(eyeBrightnessSmooth.y/240.*20.);
   #endif
   float t=1000.;
   t=min(t,texture2DLod(shadowcolor,d(e(s-vec3(0.,0.,0.),y),y)+vec2(.5,.5)/float(4096),0).w);
   t=min(t,texture2DLod(shadowcolor,d(e(s-vec3(0.,0.,0.),y),y)+vec2(-.5,-.5)/float(4096),0).w);
   t=min(t,texture2DLod(shadowcolor,d(e(s-vec3(0.,1.,0.),y),y)+vec2(0.,0.)/float(4096),0).w);
   t=min(t,texture2DLod(shadowcolor,d(e(s-vec3(0.,-1.,0.),y),y)+vec2(0.,0.)/float(4096),0).w);
   float w=texture2DLod(shadowcolor,d(e(s-vec3(0.,0.,0.),y),y),0).w;
   if(t*255.>240.||w*255.<240.)
     return vec3(0.);
   vec3 m=vec3(0.);
   for(int M=0;M<GI_SECONDARY_SAMPLES;M++)
     {
       float g=sin(frameTimeCounter*1.1)+s.x*.11+s.y*.12+s.z*.13+M*.1;
       vec3 T=normalize(rand(vec2(g))*2.-1.);
       T.x+=T.x==T.y||T.x==T.z?.01:0.;
       T.y+=T.y==T.z?.01:0.;
       vec3 c=s+vec3(1.,1.,1.);
       c=e(c,y);
       Ray p;
       p.origin=c*y-vec3(1.,1.,1.);
       p.dir=T;
       vec3 D=vec3(1.);
       float G=1000.;
       for(int S=0;S<1;S++)
         {
           vec3 l=vec3(floor(p.origin)),o=l,h=abs(vec3(length(p.dir))/(p.dir+.0001)),I=sign(p.dir),P=(sign(p.dir)*(l-p.origin)+sign(p.dir)*.5+.5)*h,O;
           vec4 N=vec4(0.);
           float Z=0.;
           vec3 a=vec3(0.);
           float R=.2;
           for(int F=0;F<DIFFUSE_TRACE_LENGTH;F++)
             {
               a=l/float(y);
               vec2 C=d(a,y);
               N=texture2DLod(shadowcolor,C,0);
               Z=N.w*255.;
               float u=1.-step(.5,abs(Z-241.));
               vec3 U=N.xyz;
               m+=U*R*u*(F==0?.5:1.);
               if(Z<240.)
                 {
                   break;
                 }
               O=step(P.xyz,P.yzx)*step(P.xyz,P.zxy);
               P+=O*h;
               l+=O*I;
               R=saturate(R*1.3);
             }
           G=distance(l.xyz,o.xyz);
           float C=0.,u=1.;
           if(abs(l.x-o.x)<2||abs(l.y-o.y)<2||abs(l.z-o.z)<2)
             u=0.;
           if(Z<1.f||Z>254.f)
             {
               vec3 F=p.dir;
               if(isEyeInWater>0)
                 F=refract(F,vec3(0.,-1.,0.),1.3333);
               vec3 U=SkyShading(F,worldSunVector,rainStrength);
               U*=saturate(F.y*10.+1.);
               U=DoNightEyeAtNight(U*12.,timeMidnight)*.083333;
               U=TintUnderwaterDepth(U);
               if(isEyeInWater>0)
                 ;
               if(length(F)<.1)
                 C=300.;
               m+=U*.1*z;
             }
           if(abs(Z-31.)<.1)
             m+=.09*N.xyz*GI_LIGHT_BLOCK_INTENSITY;
           if(Z<240.)
             {
               vec3 F=saturate(N.xyz);
               D*=F;
               vec3 U=-(O*I);
               const float E=2.4;
               vec3 b=e(a,worldLightVector,U,T,y),k=DoNightEyeAtNight(b*E*colorSunlight*u*D*z*12.,timeMidnight)/12.;
               m+=k*2.;
               m+=B(a,U)*D;
               C=G;
             }
           {
             vec2 F=IntersectSphere(s,p.dir,vec3(0.,1.5,0.),.75);
             if(G>F.y&&F.y>-.5)
               ;
           }
           UnderwaterFog(m,C,T,colorSkyUp,colorSunlight);
         }
     }
   m/=float(GI_SECONDARY_SAMPLES);
   return saturate(m);
 }
 vec4 G(float v)
 {
   float f=v*v,y=f*v;
   vec4 r;
   r.x=-y+3*f-3*v+1;
   r.y=3*y-6*f+4;
   r.z=-3*y+3*f+3*v+1;
   r.w=y;
   return r/6.f;
 }
 vec4 G(in sampler2D v,in vec2 f)
 {
   vec2 y=vec2(viewWidth,viewHeight);
   f*=y;
   f-=.5;
   float i=fract(f.x),s=fract(f.y);
   f.x-=i;
   f.y-=s;
   vec4 r=G(i),T=G(s),m=vec4(f.x-.5,f.x+1.5,f.y-.5,f.y+1.5),t=vec4(r.x+r.y,r.z+r.w,T.x+T.y,T.z+T.w),d=m+vec4(r.y,r.w,T.y,T.w)/t,z=texture2DLod(v,vec2(d.x,d.z)/y,0),x=texture2DLod(v,vec2(d.y,d.z)/y,0),h=texture2DLod(v,vec2(d.x,d.w)/y,0),c=texture2DLod(v,vec2(d.y,d.w)/y,0);
   float w=t.x/(t.x+t.y),o=t.z/(t.z+t.w);
   return mix(mix(c,h,w),mix(x,z,w),o);
 }
 bool g(vec3 v,vec3 y)
 {
   vec3 f=normalize(cross(dFdx(v),dFdy(v))),i=normalize(y-v),r=normalize(i);
   float z=.02+length(v)*.04;
   return distance(v,y)<z;
 }
 vec3 D(vec2 v)
 {
   vec2 y=vec2(viewWidth,viewHeight),f=1./y,i=v*y,z=floor(i-.5)+.5,s=i-z,r=s*s,x=s*r;
   float t=.5;
   vec2 d=-t*x+2.*t*r-t*s,m=(2.-t)*x-(3.-t)*r+1.,h=-(2.-t)*x+(3.-2.*t)*r+t*s,T=t*x-t*r,p=m+h,o=f*(z+h/p);
   vec3 F=texture2DLod(colortex4,vec2(o.x,o.y),0).xyz;
   vec2 c=f*(z-1.),P=f*(z+2.);
   vec4 n=vec4(texture2DLod(colortex4,vec2(o.x,c.y),0).xyz,1.)*(p.x*d.y)+vec4(texture2DLod(colortex4,vec2(c.x,o.y),0).xyz,1.)*(d.x*p.y)+vec4(F,1.)*(p.x*p.y)+vec4(texture2DLod(colortex4,vec2(P.x,o.y),0).xyz,1.)*(T.x*p.y)+vec4(texture2DLod(colortex4,vec2(o.x,P.y),0).xyz,1.)*(p.x*T.y);
   return max(vec3(0.),n.xyz*(1./n.w));
 }
 vec2 B(float v,vec2 f,out float r,out vec2 y,out vec4 i)
 {
   float z;
   vec2 t=GetNearFragment(texcoord.xy,v,z);
   r=texture2D(depthtex1,t).x;
   vec4 s=vec4(texcoord.xy*2.-1.,r*2.-1.,1.),T=gbufferProjectionInverse*s;
   T.xyz/=T.w;
   vec4 m=gbufferModelViewInverse*vec4(T.xyz,1.);
   i=m;
   i.xyz+=cameraPosition-previousCameraPosition;
   vec4 d=gbufferPreviousModelView*vec4(i.xyz,1.),p=gbufferPreviousProjection*vec4(d.xyz,1.);
   p.xyz/=p.w;
   y=s.xy-p.xy;
   float x=length(y)*10.,o=clamp(x*500.,0.,1.);
   vec2 g=f.xy-y.xy*.5;
   if(r<.7)
     g=texcoord.xy;
   return g;
 }
 void main()
 {
   GBufferData v=GetGBufferData();
   MaterialMask f=CalculateMasks(v.materialID);
   vec4 s=GetViewPosition(texcoord.xy,v.depth),r=gbufferModelViewInverse*vec4(s.xyz,1.),y=gbufferModelViewInverse*vec4(s.xyz,0.);
   vec3 t=normalize(s.xyz),T=normalize(y.xyz),o=normalize((gbufferModelViewInverse*vec4(v.normal,0.)).xyz),z=normalize((gbufferModelViewInverse*vec4(v.geoNormal,0.)).xyz);
   float x=length(s.xyz),m=dot(v.mcLightmap.xy,vec2(.5));
   if(f.grass>.5)
     o=vec3(0.,1.,0.),z=vec3(0.,1.,0.);
   vec4 d=vec4(texcoord.xy,0.,0.);
   float w;
   vec2 h;
   vec4 n;
   vec2 F=B(v.depth,d.xy,w,h,n),P=F.xy;
   P-=(vec2(mod(frameCounter/2,2.f),mod(frameCounter,2.f))-.5)/vec2(viewWidth,viewHeight)*1.5;
   vec3 N=D(P.xy);
   GITemporalData2 l=i(F.xy);
   float Z=1./(saturate(-dot(v.geoNormal,t))*100.+1.);
   vec4 a=vec4(F.xy,0.,0.);
   TemporalJitterProjPosPrevInv(a);
   vec4 G=gbufferPreviousProjectionInverse*vec4(F.xy*2.-1.,texture2DLod(colortex7,a.xy,0).w*2.-1.,1.);
   G/=G.w;
   vec3 C=(gbufferPreviousModelViewInverse*vec4(G.xyz,1.)).xyz;
   l.cNuyPQlxuC+=1.;
   l.cNuyPQlxuC=min(l.cNuyPQlxuC,2.);
   vec2 u=1./vec2(viewWidth,viewHeight),M=1.-u;
   float U=0.,I=1.-exp2(-l.cNuyPQlxuC);
   if(!g(n.xyz,C.xyz)||(F.x<u.x||F.x>M.x||F.y<u.y||F.y>M.y)||abs(Z-l.vfyvrzqkzI)>.01)
     I=0.,U=.99,l.cNuyPQlxuC=0.;
   float S;
   vec3 R=B(r.xyz,s.xyz,o.xyz,z,T.xyz,f,v.mcLightmap.y,h,U,S);
   R=max(vec3(0.),R);
   R=mix(R,N,vec3(I));
   l.vfyvrzqkzI=Z;
   l.xSSGSkZnBe=mix(l.xSSGSkZnBe,U,mix(.5,1.,U));
   l.ZFucbkcOTp=m;
   vec3 E=c();
   l.MXlHQOttjo=mix(B(),E,vec3(.015));
   vec4 O=p(l);
   gl_FragData[0]=vec4(R,saturate(w));
   gl_FragData[1]=vec4(O);
   gl_FragData[2]=vec4(R,S);
 };




/* DRAWBUFFERS:456 */
